/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.guardduty.model.ProductCode;

public class ProductCodeUnmarshaller
implements Unmarshaller<ProductCode, JsonUnmarshallerContext> {
    private static final ProductCodeUnmarshaller INSTANCE = new ProductCodeUnmarshaller();

    public ProductCode unmarshall(JsonUnmarshallerContext context) throws Exception {
        ProductCode.Builder productCodeBuilder = ProductCode.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("code", targetDepth)) {
                    context.nextToken();
                    productCodeBuilder.code((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("productType", targetDepth)) {
                    context.nextToken();
                    productCodeBuilder.productType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ProductCode)productCodeBuilder.build();
    }

    public static ProductCodeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

