/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Organization;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OrganizationMarshaller {
    private static final MarshallingInfo<String> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").isBinary(false).build();
    private static final MarshallingInfo<String> ASNORG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asnOrg").isBinary(false).build();
    private static final MarshallingInfo<String> ISP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isp").isBinary(false).build();
    private static final MarshallingInfo<String> ORG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("org").isBinary(false).build();
    private static final OrganizationMarshaller INSTANCE = new OrganizationMarshaller();

    private OrganizationMarshaller() {
    }

    public static OrganizationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Organization organization, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)organization, (String)"organization");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)organization.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)organization.asnOrg(), ASNORG_BINDING);
            protocolMarshaller.marshall((Object)organization.isp(), ISP_BINDING);
            protocolMarshaller.marshall((Object)organization.org(), ORG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

