/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListFindingsRequestModelMarshaller {
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FINDINGCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingCriteria").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SORTCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sortCriteria").isBinary(false).build();
    private static final ListFindingsRequestModelMarshaller INSTANCE = new ListFindingsRequestModelMarshaller();

    private ListFindingsRequestModelMarshaller() {
    }

    public static ListFindingsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListFindingsRequest listFindingsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listFindingsRequest), (String)"listFindingsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listFindingsRequest.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)listFindingsRequest.findingCriteria(), FINDINGCRITERIA_BINDING);
            protocolMarshaller.marshall((Object)listFindingsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listFindingsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listFindingsRequest.sortCriteria(), SORTCRITERIA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

