/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.DnsRequestAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DnsRequestActionMarshaller {
    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domain").isBinary(false).build();
    private static final DnsRequestActionMarshaller INSTANCE = new DnsRequestActionMarshaller();

    private DnsRequestActionMarshaller() {
    }

    public static DnsRequestActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DnsRequestAction dnsRequestAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dnsRequestAction, (String)"dnsRequestAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dnsRequestAction.domain(), DOMAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

