/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.guardduty.model.Action;
import software.amazon.awssdk.services.guardduty.transform.AwsApiCallActionUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DnsRequestActionUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.NetworkConnectionActionUnmarshaller;

public class ActionUnmarshaller
implements Unmarshaller<Action, JsonUnmarshallerContext> {
    private static final ActionUnmarshaller INSTANCE = new ActionUnmarshaller();

    public Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        Action.Builder actionBuilder = Action.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("actionType", targetDepth)) {
                    context.nextToken();
                    actionBuilder.actionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsApiCallAction", targetDepth)) {
                    context.nextToken();
                    actionBuilder.awsApiCallAction(AwsApiCallActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("dnsRequestAction", targetDepth)) {
                    context.nextToken();
                    actionBuilder.dnsRequestAction(DnsRequestActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("networkConnectionAction", targetDepth)) {
                    context.nextToken();
                    actionBuilder.networkConnectionAction(NetworkConnectionActionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Action)actionBuilder.build();
    }

    public static ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

