/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.Invitation;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;

public class ListInvitationsPublisher
implements SdkPublisher<ListInvitationsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListInvitationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvitationsPublisher(GuardDutyAsyncClient client, ListInvitationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvitationsPublisher(GuardDutyAsyncClient client, ListInvitationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvitationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Invitation> invitations() {
        Function<ListInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invitations() != null) {
                return response.invitations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListInvitationsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListInvitationsPublisher resume(ListInvitationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInvitationsPublisher(this.client, (ListInvitationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListInvitationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInvitationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInvitationsResponseFetcher
    implements AsyncPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListInvitationsResponse> nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsPublisher.this.client.listInvitations(ListInvitationsPublisher.this.firstRequest);
            }
            return ListInvitationsPublisher.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

