/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.UnprocessedAccountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnprocessedAccount
implements StructuredPojo,
ToCopyableBuilder<Builder, UnprocessedAccount> {
    private final String accountId;
    private final String result;

    private UnprocessedAccount(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.result = builder.result;
    }

    public String accountId() {
        return this.accountId;
    }

    public String result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedAccount)) {
            return false;
        }
        UnprocessedAccount other = (UnprocessedAccount)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.result(), other.result());
    }

    public String toString() {
        return ToString.builder((String)"UnprocessedAccount").add("AccountId", (Object)this.accountId()).add("Result", (Object)this.result()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "Result": {
                return Optional.of(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnprocessedAccountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String result;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedAccount model) {
            this.accountId(model.accountId);
            this.result(model.result);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public UnprocessedAccount build() {
            return new UnprocessedAccount(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnprocessedAccount> {
        public Builder accountId(String var1);

        public Builder result(String var1);
    }
}

