/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.MasterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Master
implements StructuredPojo,
ToCopyableBuilder<Builder, Master> {
    private final String accountId;
    private final String invitationId;
    private final String invitedAt;
    private final String relationshipStatus;

    private Master(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.invitationId = builder.invitationId;
        this.invitedAt = builder.invitedAt;
        this.relationshipStatus = builder.relationshipStatus;
    }

    public String accountId() {
        return this.accountId;
    }

    public String invitationId() {
        return this.invitationId;
    }

    public String invitedAt() {
        return this.invitedAt;
    }

    public String relationshipStatus() {
        return this.relationshipStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Master)) {
            return false;
        }
        Master other = (Master)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.invitationId(), other.invitationId()) && Objects.equals(this.invitedAt(), other.invitedAt()) && Objects.equals(this.relationshipStatus(), other.relationshipStatus());
    }

    public String toString() {
        return ToString.builder((String)"Master").add("AccountId", (Object)this.accountId()).add("InvitationId", (Object)this.invitationId()).add("InvitedAt", (Object)this.invitedAt()).add("RelationshipStatus", (Object)this.relationshipStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "InvitationId": {
                return Optional.of(clazz.cast(this.invitationId()));
            }
            case "InvitedAt": {
                return Optional.of(clazz.cast(this.invitedAt()));
            }
            case "RelationshipStatus": {
                return Optional.of(clazz.cast(this.relationshipStatus()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MasterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String invitationId;
        private String invitedAt;
        private String relationshipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Master model) {
            this.accountId(model.accountId);
            this.invitationId(model.invitationId);
            this.invitedAt(model.invitedAt);
            this.relationshipStatus(model.relationshipStatus);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final String getInvitedAt() {
            return this.invitedAt;
        }

        @Override
        public final Builder invitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final void setInvitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
        }

        public final String getRelationshipStatus() {
            return this.relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        public Master build() {
            return new Master(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Master> {
        public Builder accountId(String var1);

        public Builder invitationId(String var1);

        public Builder invitedAt(String var1);

        public Builder relationshipStatus(String var1);
    }
}

