/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.CountryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Country
implements StructuredPojo,
ToCopyableBuilder<Builder, Country> {
    private final String countryCode;
    private final String countryName;

    private Country(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.countryName = builder.countryName;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String countryName() {
        return this.countryName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Country)) {
            return false;
        }
        Country other = (Country)obj;
        return Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.countryName(), other.countryName());
    }

    public String toString() {
        return ToString.builder((String)"Country").add("CountryCode", (Object)this.countryCode()).add("CountryName", (Object)this.countryName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountryCode": {
                return Optional.of(clazz.cast(this.countryCode()));
            }
            case "CountryName": {
                return Optional.of(clazz.cast(this.countryName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CountryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String countryCode;
        private String countryName;

        private BuilderImpl() {
        }

        private BuilderImpl(Country model) {
            this.countryCode(model.countryCode);
            this.countryName(model.countryName);
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getCountryName() {
            return this.countryName;
        }

        @Override
        public final Builder countryName(String countryName) {
            this.countryName = countryName;
            return this;
        }

        public final void setCountryName(String countryName) {
            this.countryName = countryName;
        }

        public Country build() {
            return new Country(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Country> {
        public Builder countryCode(String var1);

        public Builder countryName(String var1);
    }
}

