/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccount;

@SdkInternalApi
public class UnprocessedAccountMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").build();
    private static final UnprocessedAccountMarshaller INSTANCE = new UnprocessedAccountMarshaller();

    public static UnprocessedAccountMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedAccount unprocessedAccount, ProtocolMarshaller protocolMarshaller) {
        if (unprocessedAccount == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)unprocessedAccount.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)unprocessedAccount.result(), RESULT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

