/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Service;

@SdkInternalApi
public class ServiceMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").build();
    private static final MarshallingInfo<Boolean> ARCHIVED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("archived").build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectorId").build();
    private static final MarshallingInfo<String> EVENTFIRSTSEEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventFirstSeen").build();
    private static final MarshallingInfo<String> EVENTLASTSEEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventLastSeen").build();
    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceRole").build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceName").build();
    private static final MarshallingInfo<String> USERFEEDBACK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userFeedback").build();
    private static final ServiceMarshaller INSTANCE = new ServiceMarshaller();

    public static ServiceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Service service, ProtocolMarshaller protocolMarshaller) {
        if (service == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)service.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)service.archived(), ARCHIVED_BINDING);
            protocolMarshaller.marshall((Object)service.count(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)service.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)service.eventFirstSeen(), EVENTFIRSTSEEN_BINDING);
            protocolMarshaller.marshall((Object)service.eventLastSeen(), EVENTLASTSEEN_BINDING);
            protocolMarshaller.marshall((Object)service.resourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall((Object)service.serviceName(), SERVICENAME_BINDING);
            protocolMarshaller.marshall((Object)service.userFeedback(), USERFEEDBACK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

