/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.SecurityGroup;

@SdkInternalApi
public class SecurityGroupMarshaller {
    private static final MarshallingInfo<String> GROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groupId").build();
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groupName").build();
    private static final SecurityGroupMarshaller INSTANCE = new SecurityGroupMarshaller();

    public static SecurityGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityGroup securityGroup, ProtocolMarshaller protocolMarshaller) {
        if (securityGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)securityGroup.groupId(), GROUPID_BINDING);
            protocolMarshaller.marshall((Object)securityGroup.groupName(), GROUPNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

