/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;

@SdkInternalApi
public class RemoteIpDetailsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("city").build();
    private static final MarshallingInfo<StructuredPojo> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("country").build();
    private static final MarshallingInfo<StructuredPojo> GEOLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("geoLocation").build();
    private static final MarshallingInfo<String> IPADDRESSV4_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddressV4").build();
    private static final MarshallingInfo<StructuredPojo> ORGANIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("organization").build();
    private static final RemoteIpDetailsMarshaller INSTANCE = new RemoteIpDetailsMarshaller();

    public static RemoteIpDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemoteIpDetails remoteIpDetails, ProtocolMarshaller protocolMarshaller) {
        if (remoteIpDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)remoteIpDetails.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.geoLocation(), GEOLOCATION_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.ipAddressV4(), IPADDRESSV4_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.organization(), ORGANIZATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

