/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Finding;

@SdkInternalApi
public class FindingMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Double> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("confidence").build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> PARTITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partition").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resource").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schemaVersion").build();
    private static final MarshallingInfo<StructuredPojo> SERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("service").build();
    private static final MarshallingInfo<Double> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severity").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").build();
    private static final FindingMarshaller INSTANCE = new FindingMarshaller();

    public static FindingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Finding finding, ProtocolMarshaller protocolMarshaller) {
        if (finding == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)finding.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)finding.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)finding.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)finding.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)finding.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)finding.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)finding.partition(), PARTITION_BINDING);
            protocolMarshaller.marshall((Object)finding.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)finding.resource(), RESOURCE_BINDING);
            protocolMarshaller.marshall((Object)finding.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)finding.service(), SERVICE_BINDING);
            protocolMarshaller.marshall((Object)finding.severity(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)finding.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)finding.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)finding.updatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

