/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Country;

@SdkInternalApi
public class CountryMarshaller {
    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("countryCode").build();
    private static final MarshallingInfo<String> COUNTRYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("countryName").build();
    private static final CountryMarshaller INSTANCE = new CountryMarshaller();

    public static CountryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Country country, ProtocolMarshaller protocolMarshaller) {
        if (country == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)country.countryCode(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)country.countryName(), COUNTRYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

