/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Condition;

@SdkInternalApi
public class ConditionMarshaller {
    private static final MarshallingInfo<List> EQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eq").build();
    private static final MarshallingInfo<Integer> GT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gt").build();
    private static final MarshallingInfo<Integer> GTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gte").build();
    private static final MarshallingInfo<Integer> LT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lt").build();
    private static final MarshallingInfo<Integer> LTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lte").build();
    private static final MarshallingInfo<List> NEQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("neq").build();
    private static final ConditionMarshaller INSTANCE = new ConditionMarshaller();

    public static ConditionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Condition condition, ProtocolMarshaller protocolMarshaller) {
        if (condition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(condition.eq(), EQ_BINDING);
            protocolMarshaller.marshall((Object)condition.gt(), GT_BINDING);
            protocolMarshaller.marshall((Object)condition.gte(), GTE_BINDING);
            protocolMarshaller.marshall((Object)condition.lt(), LT_BINDING);
            protocolMarshaller.marshall((Object)condition.lte(), LTE_BINDING);
            protocolMarshaller.marshall(condition.neq(), NEQ_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

