/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;

public final class ListThreatIntelSetsPaginator
implements SdkIterable<ListThreatIntelSetsResponse> {
    private final GuardDutyClient client;
    private final ListThreatIntelSetsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListThreatIntelSetsPaginator(GuardDutyClient client, ListThreatIntelSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThreatIntelSetsResponseFetcher();
    }

    public Iterator<ListThreatIntelSetsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> threatIntelSetIds() {
        Function<ListThreatIntelSetsResponse, Iterator> getIterator = response -> response != null ? response.threatIntelSetIds().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListThreatIntelSetsResponseFetcher
    implements NextPageFetcher<ListThreatIntelSetsResponse> {
        private ListThreatIntelSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListThreatIntelSetsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListThreatIntelSetsResponse nextPage(ListThreatIntelSetsResponse previousPage) {
            if (previousPage == null) {
                return ListThreatIntelSetsPaginator.this.client.listThreatIntelSets(ListThreatIntelSetsPaginator.this.firstRequest);
            }
            return ListThreatIntelSetsPaginator.this.client.listThreatIntelSets((ListThreatIntelSetsRequest)((Object)ListThreatIntelSetsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

