/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.Member;

public final class ListMembersPaginator
implements SdkIterable<ListMembersResponse> {
    private final GuardDutyClient client;
    private final ListMembersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListMembersPaginator(GuardDutyClient client, ListMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMembersResponseFetcher();
    }

    public Iterator<ListMembersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Member> members() {
        Function<ListMembersResponse, Iterator> getIterator = response -> response != null ? response.members().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListMembersResponseFetcher
    implements NextPageFetcher<ListMembersResponse> {
        private ListMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListMembersResponse nextPage(ListMembersResponse previousPage) {
            if (previousPage == null) {
                return ListMembersPaginator.this.client.listMembers(ListMembersPaginator.this.firstRequest);
            }
            return ListMembersPaginator.this.client.listMembers((ListMembersRequest)((Object)ListMembersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

