/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.Invitation;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;

public final class ListInvitationsPaginator
implements SdkIterable<ListInvitationsResponse> {
    private final GuardDutyClient client;
    private final ListInvitationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInvitationsPaginator(GuardDutyClient client, ListInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public Iterator<ListInvitationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Invitation> invitations() {
        Function<ListInvitationsResponse, Iterator> getIterator = response -> response != null ? response.invitations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInvitationsResponseFetcher
    implements NextPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListInvitationsResponse nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsPaginator.this.client.listInvitations(ListInvitationsPaginator.this.firstRequest);
            }
            return ListInvitationsPaginator.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

