/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListIPSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIPSetsResponse;

public final class ListIPSetsPaginator
implements SdkIterable<ListIPSetsResponse> {
    private final GuardDutyClient client;
    private final ListIPSetsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListIPSetsPaginator(GuardDutyClient client, ListIPSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIPSetsResponseFetcher();
    }

    public Iterator<ListIPSetsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> ipSetIds() {
        Function<ListIPSetsResponse, Iterator> getIterator = response -> response != null ? response.ipSetIds().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListIPSetsResponseFetcher
    implements NextPageFetcher<ListIPSetsResponse> {
        private ListIPSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListIPSetsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListIPSetsResponse nextPage(ListIPSetsResponse previousPage) {
            if (previousPage == null) {
                return ListIPSetsPaginator.this.client.listIPSets(ListIPSetsPaginator.this.firstRequest);
            }
            return ListIPSetsPaginator.this.client.listIPSets((ListIPSetsRequest)((Object)ListIPSetsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

