/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;

public final class ListFindingsPaginator
implements SdkIterable<ListFindingsResponse> {
    private final GuardDutyClient client;
    private final ListFindingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListFindingsPaginator(GuardDutyClient client, ListFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFindingsResponseFetcher();
    }

    public Iterator<ListFindingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> findingIds() {
        Function<ListFindingsResponse, Iterator> getIterator = response -> response != null ? response.findingIds().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListFindingsResponseFetcher
    implements NextPageFetcher<ListFindingsResponse> {
        private ListFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListFindingsResponse nextPage(ListFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsPaginator.this.client.listFindings(ListFindingsPaginator.this.firstRequest);
            }
            return ListFindingsPaginator.this.client.listFindings((ListFindingsRequest)((Object)ListFindingsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

