/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;

public final class ListDetectorsPaginator
implements SdkIterable<ListDetectorsResponse> {
    private final GuardDutyClient client;
    private final ListDetectorsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDetectorsPaginator(GuardDutyClient client, ListDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDetectorsResponseFetcher();
    }

    public Iterator<ListDetectorsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> detectorIds() {
        Function<ListDetectorsResponse, Iterator> getIterator = response -> response != null ? response.detectorIds().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDetectorsResponseFetcher
    implements NextPageFetcher<ListDetectorsResponse> {
        private ListDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectorsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDetectorsResponse nextPage(ListDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListDetectorsPaginator.this.client.listDetectors(ListDetectorsPaginator.this.firstRequest);
            }
            return ListDetectorsPaginator.this.client.listDetectors((ListDetectorsRequest)((Object)ListDetectorsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

