/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.guardduty.model.Feedback;
import software.amazon.awssdk.services.guardduty.model.FindingIdsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFindingsFeedbackRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateFindingsFeedbackRequest> {
    private final String comments;
    private final String detectorId;
    private final String feedback;
    private final List<String> findingIds;

    private UpdateFindingsFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.comments = builder.comments;
        this.detectorId = builder.detectorId;
        this.feedback = builder.feedback;
        this.findingIds = builder.findingIds;
    }

    public String comments() {
        return this.comments;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public Feedback feedback() {
        return Feedback.fromValue(this.feedback);
    }

    public String feedbackString() {
        return this.feedback;
    }

    public List<String> findingIds() {
        return this.findingIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comments());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsFeedbackRequest)) {
            return false;
        }
        UpdateFindingsFeedbackRequest other = (UpdateFindingsFeedbackRequest)((Object)obj);
        return Objects.equals(this.comments(), other.comments()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.feedbackString(), other.feedbackString()) && Objects.equals(this.findingIds(), other.findingIds());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFindingsFeedbackRequest").add("Comments", (Object)this.comments()).add("DetectorId", (Object)this.detectorId()).add("Feedback", (Object)this.feedbackString()).add("FindingIds", this.findingIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comments": {
                return Optional.of(clazz.cast(this.comments()));
            }
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
            case "Feedback": {
                return Optional.of(clazz.cast(this.feedbackString()));
            }
            case "FindingIds": {
                return Optional.of(clazz.cast(this.findingIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String comments;
        private String detectorId;
        private String feedback;
        private List<String> findingIds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsFeedbackRequest model) {
            this.comments(model.comments);
            this.detectorId(model.detectorId);
            this.feedback(model.feedback);
            this.findingIds(model.findingIds);
        }

        public final String getComments() {
            return this.comments;
        }

        @Override
        public final Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public final void setComments(String comments) {
            this.comments = comments;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getFeedback() {
            return this.feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(Feedback feedback) {
            this.feedback(feedback.toString());
            return this;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        public final Collection<String> getFindingIds() {
            return this.findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String ... findingIds) {
            this.findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsFeedbackRequest build() {
            return new UpdateFindingsFeedbackRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, UpdateFindingsFeedbackRequest> {
        public Builder comments(String var1);

        public Builder detectorId(String var1);

        public Builder feedback(String var1);

        public Builder feedback(Feedback var1);

        public Builder findingIds(Collection<String> var1);

        public Builder findingIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

