/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.RemotePortDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemotePortDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, RemotePortDetails> {
    private final Integer port;
    private final String portName;

    private RemotePortDetails(BuilderImpl builder) {
        this.port = builder.port;
        this.portName = builder.portName;
    }

    public Integer port() {
        return this.port;
    }

    public String portName() {
        return this.portName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.portName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemotePortDetails)) {
            return false;
        }
        RemotePortDetails other = (RemotePortDetails)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.portName(), other.portName());
    }

    public String toString() {
        return ToString.builder((String)"RemotePortDetails").add("Port", (Object)this.port()).add("PortName", (Object)this.portName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "PortName": {
                return Optional.of(clazz.cast(this.portName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemotePortDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private String portName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemotePortDetails model) {
            this.port(model.port);
            this.portName(model.portName);
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPortName() {
            return this.portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        public RemotePortDetails build() {
            return new RemotePortDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemotePortDetails> {
        public Builder port(Integer var1);

        public Builder portName(String var1);
    }
}

