/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.MemberMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Member
implements StructuredPojo,
ToCopyableBuilder<Builder, Member> {
    private final String accountId;
    private final String detectorId;
    private final String email;
    private final String invitedAt;
    private final String masterId;
    private final String relationshipStatus;
    private final String updatedAt;

    private Member(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.detectorId = builder.detectorId;
        this.email = builder.email;
        this.invitedAt = builder.invitedAt;
        this.masterId = builder.masterId;
        this.relationshipStatus = builder.relationshipStatus;
        this.updatedAt = builder.updatedAt;
    }

    public String accountId() {
        return this.accountId;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String email() {
        return this.email;
    }

    public String invitedAt() {
        return this.invitedAt;
    }

    public String masterId() {
        return this.masterId;
    }

    public String relationshipStatus() {
        return this.relationshipStatus;
    }

    public String updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.invitedAt(), other.invitedAt()) && Objects.equals(this.masterId(), other.masterId()) && Objects.equals(this.relationshipStatus(), other.relationshipStatus()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"Member").add("AccountId", (Object)this.accountId()).add("DetectorId", (Object)this.detectorId()).add("Email", (Object)this.email()).add("InvitedAt", (Object)this.invitedAt()).add("MasterId", (Object)this.masterId()).add("RelationshipStatus", (Object)this.relationshipStatus()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
            case "Email": {
                return Optional.of(clazz.cast(this.email()));
            }
            case "InvitedAt": {
                return Optional.of(clazz.cast(this.invitedAt()));
            }
            case "MasterId": {
                return Optional.of(clazz.cast(this.masterId()));
            }
            case "RelationshipStatus": {
                return Optional.of(clazz.cast(this.relationshipStatus()));
            }
            case "UpdatedAt": {
                return Optional.of(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MemberMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String detectorId;
        private String email;
        private String invitedAt;
        private String masterId;
        private String relationshipStatus;
        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.accountId(model.accountId);
            this.detectorId(model.detectorId);
            this.email(model.email);
            this.invitedAt(model.invitedAt);
            this.masterId(model.masterId);
            this.relationshipStatus(model.relationshipStatus);
            this.updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getInvitedAt() {
            return this.invitedAt;
        }

        @Override
        public final Builder invitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final void setInvitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
        }

        public final String getMasterId() {
            return this.masterId;
        }

        @Override
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        public final String getRelationshipStatus() {
            return this.relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Member build() {
            return new Member(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Member> {
        public Builder accountId(String var1);

        public Builder detectorId(String var1);

        public Builder email(String var1);

        public Builder invitedAt(String var1);

        public Builder masterId(String var1);

        public Builder relationshipStatus(String var1);

        public Builder updatedAt(String var1);
    }
}

