/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.Member;
import software.amazon.awssdk.services.guardduty.model.MembersCopier;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccount;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMembersResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetMembersResponse> {
    private final List<Member> members;
    private final List<UnprocessedAccount> unprocessedAccounts;

    private GetMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public List<Member> members() {
        return this.members;
    }

    public List<UnprocessedAccount> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.members());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedAccounts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembersResponse)) {
            return false;
        }
        GetMembersResponse other = (GetMembersResponse)((Object)obj);
        return Objects.equals(this.members(), other.members()) && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public String toString() {
        return ToString.builder((String)"GetMembersResponse").add("Members", this.members()).add("UnprocessedAccounts", this.unprocessedAccounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Members": {
                return Optional.of(clazz.cast(this.members()));
            }
            case "UnprocessedAccounts": {
                return Optional.of(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<Member> members;
        private List<UnprocessedAccount> unprocessedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMembersResponse model) {
            this.members(model.members);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<Member.Builder> getMembers() {
            return this.members != null ? (Collection)this.members.stream().map(Member::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MembersCopier.copyFromBuilder(members);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            return this.unprocessedAccounts != null ? (Collection)this.unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public GetMembersResponse build() {
            return new GetMembersResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, GetMembersResponse> {
        public Builder members(Collection<Member> var1);

        public Builder members(Member ... var1);

        public Builder unprocessedAccounts(Collection<UnprocessedAccount> var1);

        public Builder unprocessedAccounts(UnprocessedAccount ... var1);
    }
}

