/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.services.guardduty.model.FindingStatisticType;
import software.amazon.awssdk.services.guardduty.model.FindingStatisticTypesCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFindingsStatisticsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, GetFindingsStatisticsRequest> {
    private final String detectorId;
    private final FindingCriteria findingCriteria;
    private final List<String> findingStatisticTypes;

    private GetFindingsStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingCriteria = builder.findingCriteria;
        this.findingStatisticTypes = builder.findingStatisticTypes;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public List<FindingStatisticType> findingStatisticTypes() {
        return TypeConverter.convert(this.findingStatisticTypes, FindingStatisticType::fromValue);
    }

    public List<String> findingStatisticTypesStrings() {
        return this.findingStatisticTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingStatisticTypesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsStatisticsRequest)) {
            return false;
        }
        GetFindingsStatisticsRequest other = (GetFindingsStatisticsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.findingStatisticTypesStrings(), other.findingStatisticTypesStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetFindingsStatisticsRequest").add("DetectorId", (Object)this.detectorId()).add("FindingCriteria", (Object)this.findingCriteria()).add("FindingStatisticTypes", this.findingStatisticTypesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
            case "FindingCriteria": {
                return Optional.of(clazz.cast(this.findingCriteria()));
            }
            case "FindingStatisticTypes": {
                return Optional.of(clazz.cast(this.findingStatisticTypesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private FindingCriteria findingCriteria;
        private List<String> findingStatisticTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsStatisticsRequest model) {
            this.detectorId(model.detectorId);
            this.findingCriteria(model.findingCriteria);
            this.findingStatisticTypes(model.findingStatisticTypes);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        public final Collection<String> getFindingStatisticTypes() {
            return this.findingStatisticTypes;
        }

        @Override
        public final Builder findingStatisticTypes(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatisticTypes(String ... findingStatisticTypes) {
            this.findingStatisticTypes(Arrays.asList(findingStatisticTypes));
            return this;
        }

        public final void setFindingStatisticTypes(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsStatisticsRequest build() {
            return new GetFindingsStatisticsRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, GetFindingsStatisticsRequest> {
        public Builder detectorId(String var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().apply(findingCriteria)).build());
        }

        public Builder findingStatisticTypes(Collection<String> var1);

        public Builder findingStatisticTypes(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

