/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.guardduty.model.AccountDetail;
import software.amazon.awssdk.services.guardduty.model.AccountDetailsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateMembersRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreateMembersRequest> {
    private final List<AccountDetail> accountDetails;
    private final String detectorId;

    private CreateMembersRequest(BuilderImpl builder) {
        super(builder);
        this.accountDetails = builder.accountDetails;
        this.detectorId = builder.detectorId;
    }

    public List<AccountDetail> accountDetails() {
        return this.accountDetails;
    }

    public String detectorId() {
        return this.detectorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersRequest)) {
            return false;
        }
        CreateMembersRequest other = (CreateMembersRequest)((Object)obj);
        return Objects.equals(this.accountDetails(), other.accountDetails()) && Objects.equals(this.detectorId(), other.detectorId());
    }

    public String toString() {
        return ToString.builder((String)"CreateMembersRequest").add("AccountDetails", this.accountDetails()).add("DetectorId", (Object)this.detectorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountDetails": {
                return Optional.of(clazz.cast(this.accountDetails()));
            }
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private List<AccountDetail> accountDetails;
        private String detectorId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersRequest model) {
            this.accountDetails(model.accountDetails);
            this.detectorId(model.detectorId);
        }

        public final Collection<AccountDetail.Builder> getAccountDetails() {
            return this.accountDetails != null ? (Collection)this.accountDetails.stream().map(AccountDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountDetails(Collection<AccountDetail> accountDetails) {
            this.accountDetails = AccountDetailsCopier.copy(accountDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(AccountDetail ... accountDetails) {
            this.accountDetails(Arrays.asList(accountDetails));
            return this;
        }

        public final void setAccountDetails(Collection<AccountDetail.BuilderImpl> accountDetails) {
            this.accountDetails = AccountDetailsCopier.copyFromBuilder(accountDetails);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateMembersRequest build() {
            return new CreateMembersRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, CreateMembersRequest> {
        public Builder accountDetails(Collection<AccountDetail> var1);

        public Builder accountDetails(AccountDetail ... var1);

        public Builder detectorId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

