/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.AwsApiCallAction;
import software.amazon.awssdk.services.guardduty.model.DnsRequestAction;
import software.amazon.awssdk.services.guardduty.model.NetworkConnectionAction;
import software.amazon.awssdk.services.guardduty.transform.ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Action
implements StructuredPojo,
ToCopyableBuilder<Builder, Action> {
    private final String actionType;
    private final AwsApiCallAction awsApiCallAction;
    private final DnsRequestAction dnsRequestAction;
    private final NetworkConnectionAction networkConnectionAction;

    private Action(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.awsApiCallAction = builder.awsApiCallAction;
        this.dnsRequestAction = builder.dnsRequestAction;
        this.networkConnectionAction = builder.networkConnectionAction;
    }

    public String actionType() {
        return this.actionType;
    }

    public AwsApiCallAction awsApiCallAction() {
        return this.awsApiCallAction;
    }

    public DnsRequestAction dnsRequestAction() {
        return this.dnsRequestAction;
    }

    public NetworkConnectionAction networkConnectionAction() {
        return this.networkConnectionAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsApiCallAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRequestAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConnectionAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.awsApiCallAction(), other.awsApiCallAction()) && Objects.equals(this.dnsRequestAction(), other.dnsRequestAction()) && Objects.equals(this.networkConnectionAction(), other.networkConnectionAction());
    }

    public String toString() {
        return ToString.builder((String)"Action").add("ActionType", (Object)this.actionType()).add("AwsApiCallAction", (Object)this.awsApiCallAction()).add("DnsRequestAction", (Object)this.dnsRequestAction()).add("NetworkConnectionAction", (Object)this.networkConnectionAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.of(clazz.cast(this.actionType()));
            }
            case "AwsApiCallAction": {
                return Optional.of(clazz.cast(this.awsApiCallAction()));
            }
            case "DnsRequestAction": {
                return Optional.of(clazz.cast(this.dnsRequestAction()));
            }
            case "NetworkConnectionAction": {
                return Optional.of(clazz.cast(this.networkConnectionAction()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private AwsApiCallAction awsApiCallAction;
        private DnsRequestAction dnsRequestAction;
        private NetworkConnectionAction networkConnectionAction;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.actionType(model.actionType);
            this.awsApiCallAction(model.awsApiCallAction);
            this.dnsRequestAction(model.dnsRequestAction);
            this.networkConnectionAction(model.networkConnectionAction);
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final AwsApiCallAction.Builder getAwsApiCallAction() {
            return this.awsApiCallAction != null ? this.awsApiCallAction.toBuilder() : null;
        }

        @Override
        public final Builder awsApiCallAction(AwsApiCallAction awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction;
            return this;
        }

        public final void setAwsApiCallAction(AwsApiCallAction.BuilderImpl awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction != null ? awsApiCallAction.build() : null;
        }

        public final DnsRequestAction.Builder getDnsRequestAction() {
            return this.dnsRequestAction != null ? this.dnsRequestAction.toBuilder() : null;
        }

        @Override
        public final Builder dnsRequestAction(DnsRequestAction dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction;
            return this;
        }

        public final void setDnsRequestAction(DnsRequestAction.BuilderImpl dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction != null ? dnsRequestAction.build() : null;
        }

        public final NetworkConnectionAction.Builder getNetworkConnectionAction() {
            return this.networkConnectionAction != null ? this.networkConnectionAction.toBuilder() : null;
        }

        @Override
        public final Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction;
            return this;
        }

        public final void setNetworkConnectionAction(NetworkConnectionAction.BuilderImpl networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction != null ? networkConnectionAction.build() : null;
        }

        public Action build() {
            return new Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Action> {
        public Builder actionType(String var1);

        public Builder awsApiCallAction(AwsApiCallAction var1);

        default public Builder awsApiCallAction(Consumer<AwsApiCallAction.Builder> awsApiCallAction) {
            return this.awsApiCallAction((AwsApiCallAction)((AwsApiCallAction.Builder)AwsApiCallAction.builder().apply(awsApiCallAction)).build());
        }

        public Builder dnsRequestAction(DnsRequestAction var1);

        default public Builder dnsRequestAction(Consumer<DnsRequestAction.Builder> dnsRequestAction) {
            return this.dnsRequestAction((DnsRequestAction)((DnsRequestAction.Builder)DnsRequestAction.builder().apply(dnsRequestAction)).build());
        }

        public Builder networkConnectionAction(NetworkConnectionAction var1);

        default public Builder networkConnectionAction(Consumer<NetworkConnectionAction.Builder> networkConnectionAction) {
            return this.networkConnectionAction((NetworkConnectionAction)((NetworkConnectionAction.Builder)NetworkConnectionAction.builder().apply(networkConnectionAction)).build());
        }
    }
}

