/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Resource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACCESSKEYDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessKeyDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceDetails").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final ResourceMarshaller INSTANCE = new ResourceMarshaller();

    private ResourceMarshaller() {
    }

    public static ResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resource, (String)"resource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resource.accessKeyDetails(), ACCESSKEYDETAILS_BINDING);
            protocolMarshaller.marshall((Object)resource.instanceDetails(), INSTANCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)resource.resourceType(), RESOURCETYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

