/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.NetworkInterface;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NetworkInterfaceMarshaller {
    private static final MarshallingInfo<List> IPV6ADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipv6Addresses").isBinary(false).build();
    private static final MarshallingInfo<String> NETWORKINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInterfaceId").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEDNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateDnsName").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateIpAddress").isBinary(false).build();
    private static final MarshallingInfo<List> PRIVATEIPADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateIpAddresses").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICDNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicDnsName").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicIp").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroups").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnetId").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcId").isBinary(false).build();
    private static final NetworkInterfaceMarshaller INSTANCE = new NetworkInterfaceMarshaller();

    private NetworkInterfaceMarshaller() {
    }

    public static NetworkInterfaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkInterface networkInterface, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)networkInterface, (String)"networkInterface");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(networkInterface.ipv6Addresses(), IPV6ADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.networkInterfaceId(), NETWORKINTERFACEID_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.privateDnsName(), PRIVATEDNSNAME_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.privateIpAddress(), PRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall(networkInterface.privateIpAddresses(), PRIVATEIPADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.publicDnsName(), PUBLICDNSNAME_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.publicIp(), PUBLICIP_BINDING);
            protocolMarshaller.marshall(networkInterface.securityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.vpcId(), VPCID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

