/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.GetFilterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetFilterRequestModelMarshaller {
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<String> FILTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("filterName").isBinary(false).build();
    private static final GetFilterRequestModelMarshaller INSTANCE = new GetFilterRequestModelMarshaller();

    private GetFilterRequestModelMarshaller() {
    }

    public static GetFilterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetFilterRequest getFilterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getFilterRequest), (String)"getFilterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getFilterRequest.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)getFilterRequest.filterName(), FILTERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

