/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.GeoLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GeoLocationMarshaller {
    private static final MarshallingInfo<Double> LAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lat").isBinary(false).build();
    private static final MarshallingInfo<Double> LON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lon").isBinary(false).build();
    private static final GeoLocationMarshaller INSTANCE = new GeoLocationMarshaller();

    private GeoLocationMarshaller() {
    }

    public static GeoLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GeoLocation geoLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)geoLocation, (String)"geoLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)geoLocation.lat(), LAT_BINDING);
            protocolMarshaller.marshall((Object)geoLocation.lon(), LON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

