/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FindingCriteriaMarshaller {
    private static final MarshallingInfo<Map> CRITERION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("criterion").isBinary(false).build();
    private static final FindingCriteriaMarshaller INSTANCE = new FindingCriteriaMarshaller();

    private FindingCriteriaMarshaller() {
    }

    public static FindingCriteriaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FindingCriteria findingCriteria, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)findingCriteria, (String)"findingCriteria");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(findingCriteria.criterion(), CRITERION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

