/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateIpSetRequestModelMarshaller {
    private static final MarshallingInfo<Boolean> ACTIVATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activate").isBinary(false).build();
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final CreateIpSetRequestModelMarshaller INSTANCE = new CreateIpSetRequestModelMarshaller();

    private CreateIpSetRequestModelMarshaller() {
    }

    public static CreateIpSetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateIpSetRequest createIpSetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createIpSetRequest), (String)"createIpSetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createIpSetRequest.activate(), ACTIVATE_BINDING);
            protocolMarshaller.marshall((Object)createIpSetRequest.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)createIpSetRequest.formatAsString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)createIpSetRequest.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)createIpSetRequest.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

