/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.guardduty.model.CreateFilterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateFilterRequestModelMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FINDINGCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingCriteria").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Integer> RANK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rank").isBinary(false).build();
    private static final CreateFilterRequestModelMarshaller INSTANCE = new CreateFilterRequestModelMarshaller();

    private CreateFilterRequestModelMarshaller() {
    }

    public static CreateFilterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateFilterRequest createFilterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createFilterRequest), (String)"createFilterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createFilterRequest.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)createFilterRequest.clientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createFilterRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createFilterRequest.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)createFilterRequest.findingCriteria(), FINDINGCRITERIA_BINDING);
            protocolMarshaller.marshall((Object)createFilterRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createFilterRequest.rank(), RANK_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

