/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.guardduty.model.FilterAction;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFilterRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateFilterRequest> {
    private final String action;
    private final String description;
    private final String detectorId;
    private final String filterName;
    private final FindingCriteria findingCriteria;
    private final Integer rank;

    private UpdateFilterRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.description = builder.description;
        this.detectorId = builder.detectorId;
        this.filterName = builder.filterName;
        this.findingCriteria = builder.findingCriteria;
        this.rank = builder.rank;
    }

    public FilterAction action() {
        return FilterAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String description() {
        return this.description;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String filterName() {
        return this.filterName;
    }

    public FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public Integer rank() {
        return this.rank;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFilterRequest)) {
            return false;
        }
        UpdateFilterRequest other = (UpdateFilterRequest)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.rank(), other.rank());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFilterRequest").add("Action", (Object)this.actionAsString()).add("Description", (Object)this.description()).add("DetectorId", (Object)this.detectorId()).add("FilterName", (Object)this.filterName()).add("FindingCriteria", (Object)this.findingCriteria()).add("Rank", (Object)this.rank()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FilterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "FindingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "Rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String action;
        private String description;
        private String detectorId;
        private String filterName;
        private FindingCriteria findingCriteria;
        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFilterRequest model) {
            super(model);
            this.action(model.action);
            this.description(model.description);
            this.detectorId(model.detectorId);
            this.filterName(model.filterName);
            this.findingCriteria(model.findingCriteria);
            this.rank(model.rank);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FilterAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        public final Integer getRank() {
            return this.rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFilterRequest build() {
            return new UpdateFilterRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, UpdateFilterRequest> {
        public Builder action(String var1);

        public Builder action(FilterAction var1);

        public Builder description(String var1);

        public Builder detectorId(String var1);

        public Builder filterName(String var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder rank(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

