/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccount;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMonitoringMembersResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, StartMonitoringMembersResponse> {
    private final List<UnprocessedAccount> unprocessedAccounts;

    private StartMonitoringMembersResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public List<UnprocessedAccount> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedAccounts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMonitoringMembersResponse)) {
            return false;
        }
        StartMonitoringMembersResponse other = (StartMonitoringMembersResponse)((Object)obj);
        return Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public String toString() {
        return ToString.builder((String)"StartMonitoringMembersResponse").add("UnprocessedAccounts", this.unprocessedAccounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMonitoringMembersResponse model) {
            super(model);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            return this.unprocessedAccounts != null ? (Collection)this.unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (UnprocessedAccount)((UnprocessedAccount.Builder)UnprocessedAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public StartMonitoringMembersResponse build() {
            return new StartMonitoringMembersResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, StartMonitoringMembersResponse> {
        public Builder unprocessedAccounts(Collection<UnprocessedAccount> var1);

        public Builder unprocessedAccounts(UnprocessedAccount ... var1);

        public Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... var1);
    }
}

