/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.OrderBy;
import software.amazon.awssdk.services.guardduty.transform.SortCriteriaMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SortCriteria
implements StructuredPojo,
ToCopyableBuilder<Builder, SortCriteria> {
    private final String attributeName;
    private final String orderBy;

    private SortCriteria(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.orderBy = builder.orderBy;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public OrderBy orderBy() {
        return OrderBy.fromValue(this.orderBy);
    }

    public String orderByAsString() {
        return this.orderBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortCriteria)) {
            return false;
        }
        SortCriteria other = (SortCriteria)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.orderByAsString(), other.orderByAsString());
    }

    public String toString() {
        return ToString.builder((String)"SortCriteria").add("AttributeName", (Object)this.attributeName()).add("OrderBy", (Object)this.orderByAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "OrderBy": {
                return Optional.ofNullable(clazz.cast(this.orderByAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SortCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SortCriteria model) {
            this.attributeName(model.attributeName);
            this.orderBy(model.orderBy);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy.toString());
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public SortCriteria build() {
            return new SortCriteria(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SortCriteria> {
        public Builder attributeName(String var1);

        public Builder orderBy(String var1);

        public Builder orderBy(OrderBy var1);
    }
}

