/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Action;
import software.amazon.awssdk.services.guardduty.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements StructuredPojo,
ToCopyableBuilder<Builder, Service> {
    private final Action action;
    private final Boolean archived;
    private final Integer count;
    private final String detectorId;
    private final String eventFirstSeen;
    private final String eventLastSeen;
    private final String resourceRole;
    private final String serviceName;
    private final String userFeedback;

    private Service(BuilderImpl builder) {
        this.action = builder.action;
        this.archived = builder.archived;
        this.count = builder.count;
        this.detectorId = builder.detectorId;
        this.eventFirstSeen = builder.eventFirstSeen;
        this.eventLastSeen = builder.eventLastSeen;
        this.resourceRole = builder.resourceRole;
        this.serviceName = builder.serviceName;
        this.userFeedback = builder.userFeedback;
    }

    public Action action() {
        return this.action;
    }

    public Boolean archived() {
        return this.archived;
    }

    public Integer count() {
        return this.count;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String eventFirstSeen() {
        return this.eventFirstSeen;
    }

    public String eventLastSeen() {
        return this.eventLastSeen;
    }

    public String resourceRole() {
        return this.resourceRole;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String userFeedback() {
        return this.userFeedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.archived());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventFirstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventLastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userFeedback());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.archived(), other.archived()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.eventFirstSeen(), other.eventFirstSeen()) && Objects.equals(this.eventLastSeen(), other.eventLastSeen()) && Objects.equals(this.resourceRole(), other.resourceRole()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.userFeedback(), other.userFeedback());
    }

    public String toString() {
        return ToString.builder((String)"Service").add("Action", (Object)this.action()).add("Archived", (Object)this.archived()).add("Count", (Object)this.count()).add("DetectorId", (Object)this.detectorId()).add("EventFirstSeen", (Object)this.eventFirstSeen()).add("EventLastSeen", (Object)this.eventLastSeen()).add("ResourceRole", (Object)this.resourceRole()).add("ServiceName", (Object)this.serviceName()).add("UserFeedback", (Object)this.userFeedback()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Archived": {
                return Optional.ofNullable(clazz.cast(this.archived()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "EventFirstSeen": {
                return Optional.ofNullable(clazz.cast(this.eventFirstSeen()));
            }
            case "EventLastSeen": {
                return Optional.ofNullable(clazz.cast(this.eventLastSeen()));
            }
            case "ResourceRole": {
                return Optional.ofNullable(clazz.cast(this.resourceRole()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "UserFeedback": {
                return Optional.ofNullable(clazz.cast(this.userFeedback()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Action action;
        private Boolean archived;
        private Integer count;
        private String detectorId;
        private String eventFirstSeen;
        private String eventLastSeen;
        private String resourceRole;
        private String serviceName;
        private String userFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.action(model.action);
            this.archived(model.archived);
            this.count(model.count);
            this.detectorId(model.detectorId);
            this.eventFirstSeen(model.eventFirstSeen);
            this.eventLastSeen(model.eventLastSeen);
            this.resourceRole(model.resourceRole);
            this.serviceName(model.serviceName);
            this.userFeedback(model.userFeedback);
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final Boolean getArchived() {
            return this.archived;
        }

        @Override
        public final Builder archived(Boolean archived) {
            this.archived = archived;
            return this;
        }

        public final void setArchived(Boolean archived) {
            this.archived = archived;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getEventFirstSeen() {
            return this.eventFirstSeen;
        }

        @Override
        public final Builder eventFirstSeen(String eventFirstSeen) {
            this.eventFirstSeen = eventFirstSeen;
            return this;
        }

        public final void setEventFirstSeen(String eventFirstSeen) {
            this.eventFirstSeen = eventFirstSeen;
        }

        public final String getEventLastSeen() {
            return this.eventLastSeen;
        }

        @Override
        public final Builder eventLastSeen(String eventLastSeen) {
            this.eventLastSeen = eventLastSeen;
            return this;
        }

        public final void setEventLastSeen(String eventLastSeen) {
            this.eventLastSeen = eventLastSeen;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getUserFeedback() {
            return this.userFeedback;
        }

        @Override
        public final Builder userFeedback(String userFeedback) {
            this.userFeedback = userFeedback;
            return this;
        }

        public final void setUserFeedback(String userFeedback) {
            this.userFeedback = userFeedback;
        }

        public Service build() {
            return new Service(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Service> {
        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder archived(Boolean var1);

        public Builder count(Integer var1);

        public Builder detectorId(String var1);

        public Builder eventFirstSeen(String var1);

        public Builder eventLastSeen(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceName(String var1);

        public Builder userFeedback(String var1);
    }
}

