/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.AccessKeyDetails;
import software.amazon.awssdk.services.guardduty.model.InstanceDetails;
import software.amazon.awssdk.services.guardduty.transform.ResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements StructuredPojo,
ToCopyableBuilder<Builder, Resource> {
    private final AccessKeyDetails accessKeyDetails;
    private final InstanceDetails instanceDetails;
    private final String resourceType;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.instanceDetails = builder.instanceDetails;
        this.resourceType = builder.resourceType;
    }

    public AccessKeyDetails accessKeyDetails() {
        return this.accessKeyDetails;
    }

    public InstanceDetails instanceDetails() {
        return this.instanceDetails;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.accessKeyDetails(), other.accessKeyDetails()) && Objects.equals(this.instanceDetails(), other.instanceDetails()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public String toString() {
        return ToString.builder((String)"Resource").add("AccessKeyDetails", (Object)this.accessKeyDetails()).add("InstanceDetails", (Object)this.instanceDetails()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.accessKeyDetails()));
            }
            case "InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.instanceDetails()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessKeyDetails accessKeyDetails;
        private InstanceDetails instanceDetails;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.accessKeyDetails(model.accessKeyDetails);
            this.instanceDetails(model.instanceDetails);
            this.resourceType(model.resourceType);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return this.accessKeyDetails != null ? this.accessKeyDetails.toBuilder() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return this.instanceDetails != null ? this.instanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Resource build() {
            return new Resource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Resource> {
        public Builder accessKeyDetails(AccessKeyDetails var1);

        default public Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return this.accessKeyDetails((AccessKeyDetails)((AccessKeyDetails.Builder)AccessKeyDetails.builder().applyMutation(accessKeyDetails)).build());
        }

        public Builder instanceDetails(InstanceDetails var1);

        default public Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return this.instanceDetails((InstanceDetails)((InstanceDetails.Builder)InstanceDetails.builder().applyMutation(instanceDetails)).build());
        }

        public Builder resourceType(String var1);
    }
}

