/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.PortProbeDetail;
import software.amazon.awssdk.services.guardduty.model.___listOfPortProbeDetailCopier;
import software.amazon.awssdk.services.guardduty.transform.PortProbeActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortProbeAction
implements StructuredPojo,
ToCopyableBuilder<Builder, PortProbeAction> {
    private final Boolean blocked;
    private final List<PortProbeDetail> portProbeDetails;

    private PortProbeAction(BuilderImpl builder) {
        this.blocked = builder.blocked;
        this.portProbeDetails = builder.portProbeDetails;
    }

    public Boolean blocked() {
        return this.blocked;
    }

    public List<PortProbeDetail> portProbeDetails() {
        return this.portProbeDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blocked());
        hashCode = 31 * hashCode + Objects.hashCode(this.portProbeDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortProbeAction)) {
            return false;
        }
        PortProbeAction other = (PortProbeAction)obj;
        return Objects.equals(this.blocked(), other.blocked()) && Objects.equals(this.portProbeDetails(), other.portProbeDetails());
    }

    public String toString() {
        return ToString.builder((String)"PortProbeAction").add("Blocked", (Object)this.blocked()).add("PortProbeDetails", this.portProbeDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blocked": {
                return Optional.ofNullable(clazz.cast(this.blocked()));
            }
            case "PortProbeDetails": {
                return Optional.ofNullable(clazz.cast(this.portProbeDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortProbeActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean blocked;
        private List<PortProbeDetail> portProbeDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortProbeAction model) {
            this.blocked(model.blocked);
            this.portProbeDetails(model.portProbeDetails);
        }

        public final Boolean getBlocked() {
            return this.blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        public final Collection<PortProbeDetail.Builder> getPortProbeDetails() {
            return this.portProbeDetails != null ? (Collection)this.portProbeDetails.stream().map(PortProbeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portProbeDetails(Collection<PortProbeDetail> portProbeDetails) {
            this.portProbeDetails = ___listOfPortProbeDetailCopier.copy(portProbeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portProbeDetails(PortProbeDetail ... portProbeDetails) {
            this.portProbeDetails(Arrays.asList(portProbeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portProbeDetails(Consumer<PortProbeDetail.Builder> ... portProbeDetails) {
            this.portProbeDetails(Stream.of(portProbeDetails).map(c -> (PortProbeDetail)((PortProbeDetail.Builder)PortProbeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortProbeDetails(Collection<PortProbeDetail.BuilderImpl> portProbeDetails) {
            this.portProbeDetails = ___listOfPortProbeDetailCopier.copyFromBuilder(portProbeDetails);
        }

        public PortProbeAction build() {
            return new PortProbeAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PortProbeAction> {
        public Builder blocked(Boolean var1);

        public Builder portProbeDetails(Collection<PortProbeDetail> var1);

        public Builder portProbeDetails(PortProbeDetail ... var1);

        public Builder portProbeDetails(Consumer<PortProbeDetail.Builder> ... var1);
    }
}

