/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.LocalPortDetails;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.services.guardduty.model.RemotePortDetails;
import software.amazon.awssdk.services.guardduty.transform.NetworkConnectionActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkConnectionAction
implements StructuredPojo,
ToCopyableBuilder<Builder, NetworkConnectionAction> {
    private final Boolean blocked;
    private final String connectionDirection;
    private final LocalPortDetails localPortDetails;
    private final String protocol;
    private final RemoteIpDetails remoteIpDetails;
    private final RemotePortDetails remotePortDetails;

    private NetworkConnectionAction(BuilderImpl builder) {
        this.blocked = builder.blocked;
        this.connectionDirection = builder.connectionDirection;
        this.localPortDetails = builder.localPortDetails;
        this.protocol = builder.protocol;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.remotePortDetails = builder.remotePortDetails;
    }

    public Boolean blocked() {
        return this.blocked;
    }

    public String connectionDirection() {
        return this.connectionDirection;
    }

    public LocalPortDetails localPortDetails() {
        return this.localPortDetails;
    }

    public String protocol() {
        return this.protocol;
    }

    public RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public RemotePortDetails remotePortDetails() {
        return this.remotePortDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blocked());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDirection());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remotePortDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConnectionAction)) {
            return false;
        }
        NetworkConnectionAction other = (NetworkConnectionAction)obj;
        return Objects.equals(this.blocked(), other.blocked()) && Objects.equals(this.connectionDirection(), other.connectionDirection()) && Objects.equals(this.localPortDetails(), other.localPortDetails()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.remotePortDetails(), other.remotePortDetails());
    }

    public String toString() {
        return ToString.builder((String)"NetworkConnectionAction").add("Blocked", (Object)this.blocked()).add("ConnectionDirection", (Object)this.connectionDirection()).add("LocalPortDetails", (Object)this.localPortDetails()).add("Protocol", (Object)this.protocol()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("RemotePortDetails", (Object)this.remotePortDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blocked": {
                return Optional.ofNullable(clazz.cast(this.blocked()));
            }
            case "ConnectionDirection": {
                return Optional.ofNullable(clazz.cast(this.connectionDirection()));
            }
            case "LocalPortDetails": {
                return Optional.ofNullable(clazz.cast(this.localPortDetails()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "RemotePortDetails": {
                return Optional.ofNullable(clazz.cast(this.remotePortDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkConnectionActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean blocked;
        private String connectionDirection;
        private LocalPortDetails localPortDetails;
        private String protocol;
        private RemoteIpDetails remoteIpDetails;
        private RemotePortDetails remotePortDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConnectionAction model) {
            this.blocked(model.blocked);
            this.connectionDirection(model.connectionDirection);
            this.localPortDetails(model.localPortDetails);
            this.protocol(model.protocol);
            this.remoteIpDetails(model.remoteIpDetails);
            this.remotePortDetails(model.remotePortDetails);
        }

        public final Boolean getBlocked() {
            return this.blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        public final String getConnectionDirection() {
            return this.connectionDirection;
        }

        @Override
        public final Builder connectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
            return this;
        }

        public final void setConnectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
        }

        public final LocalPortDetails.Builder getLocalPortDetails() {
            return this.localPortDetails != null ? this.localPortDetails.toBuilder() : null;
        }

        @Override
        public final Builder localPortDetails(LocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final void setLocalPortDetails(LocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        public final RemotePortDetails.Builder getRemotePortDetails() {
            return this.remotePortDetails != null ? this.remotePortDetails.toBuilder() : null;
        }

        @Override
        public final Builder remotePortDetails(RemotePortDetails remotePortDetails) {
            this.remotePortDetails = remotePortDetails;
            return this;
        }

        public final void setRemotePortDetails(RemotePortDetails.BuilderImpl remotePortDetails) {
            this.remotePortDetails = remotePortDetails != null ? remotePortDetails.build() : null;
        }

        public NetworkConnectionAction build() {
            return new NetworkConnectionAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkConnectionAction> {
        public Builder blocked(Boolean var1);

        public Builder connectionDirection(String var1);

        public Builder localPortDetails(LocalPortDetails var1);

        default public Builder localPortDetails(Consumer<LocalPortDetails.Builder> localPortDetails) {
            return this.localPortDetails((LocalPortDetails)((LocalPortDetails.Builder)LocalPortDetails.builder().applyMutation(localPortDetails)).build());
        }

        public Builder protocol(String var1);

        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder remotePortDetails(RemotePortDetails var1);

        default public Builder remotePortDetails(Consumer<RemotePortDetails.Builder> remotePortDetails) {
            return this.remotePortDetails((RemotePortDetails)((RemotePortDetails.Builder)RemotePortDetails.builder().applyMutation(remotePortDetails)).build());
        }
    }
}

