/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.Member;
import software.amazon.awssdk.services.guardduty.model.MembersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembersResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListMembersResponse> {
    private final List<Member> members;
    private final String nextToken;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.nextToken = builder.nextToken;
    }

    public List<Member> members() {
        return this.members;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.members());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse)((Object)obj);
        return Objects.equals(this.members(), other.members()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMembersResponse").add("Members", this.members()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<Member> members = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            this.members(model.members);
            this.nextToken(model.nextToken);
        }

        public final Collection<Member.Builder> getMembers() {
            return this.members != null ? (Collection)this.members.stream().map(Member::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Member.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (Member)((Member.Builder)Member.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MembersCopier.copyFromBuilder(members);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, ListMembersResponse> {
        public Builder members(Collection<Member> var1);

        public Builder members(Member ... var1);

        public Builder members(Consumer<Member.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

