/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.FilterNamesCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFiltersResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListFiltersResponse> {
    private final List<String> filterNames;
    private final String nextToken;

    private ListFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.filterNames = builder.filterNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> filterNames() {
        return this.filterNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFiltersResponse)) {
            return false;
        }
        ListFiltersResponse other = (ListFiltersResponse)((Object)obj);
        return Objects.equals(this.filterNames(), other.filterNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFiltersResponse").add("FilterNames", this.filterNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterNames": {
                return Optional.ofNullable(clazz.cast(this.filterNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<String> filterNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFiltersResponse model) {
            super(model);
            this.filterNames(model.filterNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFilterNames() {
            return this.filterNames;
        }

        @Override
        public final Builder filterNames(Collection<String> filterNames) {
            this.filterNames = FilterNamesCopier.copy(filterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterNames(String ... filterNames) {
            this.filterNames(Arrays.asList(filterNames));
            return this;
        }

        public final void setFilterNames(Collection<String> filterNames) {
            this.filterNames = FilterNamesCopier.copy(filterNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFiltersResponse build() {
            return new ListFiltersResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, ListFiltersResponse> {
        public Builder filterNames(Collection<String> var1);

        public Builder filterNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

