/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AccountIdsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InviteMembersRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, InviteMembersRequest> {
    private final List<String> accountIds;
    private final String detectorId;
    private final Boolean disableEmailNotification;
    private final String message;

    private InviteMembersRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.detectorId = builder.detectorId;
        this.disableEmailNotification = builder.disableEmailNotification;
        this.message = builder.message;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public Boolean disableEmailNotification() {
        return this.disableEmailNotification;
    }

    public String message() {
        return this.message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableEmailNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteMembersRequest)) {
            return false;
        }
        InviteMembersRequest other = (InviteMembersRequest)((Object)obj);
        return Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.disableEmailNotification(), other.disableEmailNotification()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"InviteMembersRequest").add("AccountIds", this.accountIds()).add("DetectorId", (Object)this.detectorId()).add("DisableEmailNotification", (Object)this.disableEmailNotification()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "DisableEmailNotification": {
                return Optional.ofNullable(clazz.cast(this.disableEmailNotification()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private String detectorId;
        private Boolean disableEmailNotification;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InviteMembersRequest model) {
            super(model);
            this.accountIds(model.accountIds);
            this.detectorId(model.detectorId);
            this.disableEmailNotification(model.disableEmailNotification);
            this.message(model.message);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Boolean getDisableEmailNotification() {
            return this.disableEmailNotification;
        }

        @Override
        public final Builder disableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
            return this;
        }

        public final void setDisableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InviteMembersRequest build() {
            return new InviteMembersRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, InviteMembersRequest> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder detectorId(String var1);

        public Builder disableEmailNotification(Boolean var1);

        public Builder message(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

