/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.guardduty.model.FilterAction;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFilterResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetFilterResponse> {
    private final String action;
    private final String description;
    private final FindingCriteria findingCriteria;
    private final String name;
    private final Integer rank;

    private GetFilterResponse(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.description = builder.description;
        this.findingCriteria = builder.findingCriteria;
        this.name = builder.name;
        this.rank = builder.rank;
    }

    public FilterAction action() {
        return FilterAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String description() {
        return this.description;
    }

    public FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public String name() {
        return this.name;
    }

    public Integer rank() {
        return this.rank;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFilterResponse)) {
            return false;
        }
        GetFilterResponse other = (GetFilterResponse)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.rank(), other.rank());
    }

    public String toString() {
        return ToString.builder((String)"GetFilterResponse").add("Action", (Object)this.actionAsString()).add("Description", (Object)this.description()).add("FindingCriteria", (Object)this.findingCriteria()).add("Name", (Object)this.name()).add("Rank", (Object)this.rank()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FindingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String action;
        private String description;
        private FindingCriteria findingCriteria;
        private String name;
        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFilterResponse model) {
            super(model);
            this.action(model.action);
            this.description(model.description);
            this.findingCriteria(model.findingCriteria);
            this.name(model.name);
            this.rank(model.rank);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FilterAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRank() {
            return this.rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public GetFilterResponse build() {
            return new GetFilterResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, GetFilterResponse> {
        public Builder action(String var1);

        public Builder action(FilterAction var1);

        public Builder description(String var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder name(String var1);

        public Builder rank(Integer var1);
    }
}

