/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.guardduty.model.DetectorStatus;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDetectorResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetDetectorResponse> {
    private final String createdAt;
    private final String serviceRole;
    private final String status;
    private final String updatedAt;

    private GetDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public DetectorStatus status() {
        return DetectorStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorResponse)) {
            return false;
        }
        GetDetectorResponse other = (GetDetectorResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"GetDetectorResponse").add("CreatedAt", (Object)this.createdAt()).add("ServiceRole", (Object)this.serviceRole()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String createdAt;
        private String serviceRole;
        private String status;
        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.serviceRole(model.serviceRole);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectorStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public GetDetectorResponse build() {
            return new GetDetectorResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, GetDetectorResponse> {
        public Builder createdAt(String var1);

        public Builder serviceRole(String var1);

        public Builder status(String var1);

        public Builder status(DetectorStatus var1);

        public Builder updatedAt(String var1);
    }
}

