/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.GeoLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, GeoLocation> {
    private final Double lat;
    private final Double lon;

    private GeoLocation(BuilderImpl builder) {
        this.lat = builder.lat;
        this.lon = builder.lon;
    }

    public Double lat() {
        return this.lat;
    }

    public Double lon() {
        return this.lon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lat());
        hashCode = 31 * hashCode + Objects.hashCode(this.lon());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)obj;
        return Objects.equals(this.lat(), other.lat()) && Objects.equals(this.lon(), other.lon());
    }

    public String toString() {
        return ToString.builder((String)"GeoLocation").add("Lat", (Object)this.lat()).add("Lon", (Object)this.lon()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Lat": {
                return Optional.ofNullable(clazz.cast(this.lat()));
            }
            case "Lon": {
                return Optional.ofNullable(clazz.cast(this.lon()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeoLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double lat;
        private Double lon;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocation model) {
            this.lat(model.lat);
            this.lon(model.lon);
        }

        public final Double getLat() {
            return this.lat;
        }

        @Override
        public final Builder lat(Double lat) {
            this.lat = lat;
            return this;
        }

        public final void setLat(Double lat) {
            this.lat = lat;
        }

        public final Double getLon() {
            return this.lon;
        }

        @Override
        public final Builder lon(Double lon) {
            this.lon = lon;
            return this;
        }

        public final void setLon(Double lon) {
            this.lon = lon;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GeoLocation> {
        public Builder lat(Double var1);

        public Builder lon(Double var1);
    }
}

