/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteThreatIntelSetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, DeleteThreatIntelSetRequest> {
    private final String detectorId;
    private final String threatIntelSetId;

    private DeleteThreatIntelSetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.threatIntelSetId = builder.threatIntelSetId;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String threatIntelSetId() {
        return this.threatIntelSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatIntelSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThreatIntelSetRequest)) {
            return false;
        }
        DeleteThreatIntelSetRequest other = (DeleteThreatIntelSetRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.threatIntelSetId(), other.threatIntelSetId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteThreatIntelSetRequest").add("DetectorId", (Object)this.detectorId()).add("ThreatIntelSetId", (Object)this.threatIntelSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "ThreatIntelSetId": {
                return Optional.ofNullable(clazz.cast(this.threatIntelSetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String threatIntelSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThreatIntelSetRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.threatIntelSetId(model.threatIntelSetId);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getThreatIntelSetId() {
            return this.threatIntelSetId;
        }

        @Override
        public final Builder threatIntelSetId(String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
            return this;
        }

        public final void setThreatIntelSetId(String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteThreatIntelSetRequest build() {
            return new DeleteThreatIntelSetRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, DeleteThreatIntelSetRequest> {
        public Builder detectorId(String var1);

        public Builder threatIntelSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

